CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'est_orc_cpl_pbm') THEN 
        CREATE TABLE est_orc_cpl_pbm (
            cd_emp int,
            cd_filial int,
            cd_orc int,
            cd_it int,
            id_terminal text,
            nsu_req text,
            numero_sessao text,
            cd_projeto_ext numeric,
            cgc_cpf text,
            perc_desc_unit_pbm numeric(10, 2),
            vlr_desc_unit_pbm numeric(10, 2),
            vlr_unit_pbm numeric(10, 2),
            flag_upload_receita_medica int,
            flag_exige_receita_medica int,
            id_campanha int,
            pre_autorizacao text,
            numero_autorizacao text,
            tipo_pbm int,
			cd_projeto int,
			CONSTRAINT est_orc_cpl_pbm_pkey PRIMARY KEY (cd_emp, cd_filial, cd_orc, cd_it), 
            CONSTRAINT est_orc_cpl_pbm_cd_emp_fkey FOREIGN KEY (cd_emp, cd_filial, cd_orc, cd_it) REFERENCES est_orc_cpl(cd_emp, cd_filial, cd_orc, cd_it)
        )
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA est_orc_cpl_pbm %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();